class Respawnables_Weapon_Bazooka expands Respawnables_Weapon;

#exec TEXTURE IMPORT NAME=sight FILE=Textures\sight.bmp MIPS=off
#exec TEXTURE IMPORT NAME=sight2 FILE=Textures\sight2.bmp MIPS=off

////right version///
#exec MESH IMPORT MESH=plaunrght ANIVFILE=Models\plaunrght_a.3D  DATAFILE=Models\plaunrght_d.3D X=0 Y=0 Z=0 unmirror=1
#exec MESH ORIGIN MESH=plaunrght X=190 Y=170 Z=130 YAW=-128 ROLL=0
#exec MESH SEQUENCE MESH=plaunrght SEQ=All      STARTFRAME=0   NUMFRAMES=27
#exec MESH SEQUENCE MESH=plaunrght SEQ=Select   STARTFRAME=0   NUMFRAMES=5 RATE=5 GROUP=Select
#exec MESH SEQUENCE MESH=plaunrght SEQ=Still    STARTFRAME=5  NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunrght SEQ=altfire    STARTFRAME=5  NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunrght SEQ=sway     STARTFRAME=5  NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunrght SEQ=Fire    STARTFRAME=6  NUMFRAMES=4 rate=4
#exec MESH SEQUENCE MESH=plaunrght SEQ=loading    STARTFRAME=9  NUMFRAMES=11 rate=6
#exec MESH SEQUENCE MESH=plaunrght SEQ=Down     STARTFRAME=20 NUMFRAMES=6
#exec TEXTURE IMPORT NAME=Jrlauncher FILE=Textures\Jrlauncher.bmp GROUP=Skins FLAGS=2 // skins
#exec TEXTURE IMPORT NAME=Jrlauncher1 FILE=Textures\Jrlauncher1.bmp GROUP=Skins FLAGS=2 // skins
#exec TEXTURE IMPORT NAME=Jrlauncher2 FILE=Textures\Jrlauncher2.bmp GROUP=Skins FLAGS=2 // skins

#exec MESHMAP NEW   MESHMAP=plaunrght MESH=plaunrght
#exec MESHMAP SCALE MESHMAP=plaunrght X=0.008 Y=0.008 Z=0.016
 
#exec MESHMAP SETTEXTURE MESHMAP=plaunrght NUM=0 TEXTURE=Jrlauncher
#exec MESHMAP SETTEXTURE MESHMAP=plaunrght NUM=1 TEXTURE=Jrlauncher1
#exec MESHMAP SETTEXTURE MESHMAP=plaunrght NUM=2 TEXTURE=Jrlauncher2

///left version////
#exec MESH IMPORT MESH=plaunlft ANIVFILE=Models\plaunlft_a.3D  DATAFILE=Models\plaunlft_d.3D X=0 Y=0 Z=0 
#exec MESH ORIGIN MESH=plaunlft X=-190 Y=-170 Z=130 
#exec MESH SEQUENCE MESH=plaunlft SEQ=All      STARTFRAME=0   NUMFRAMES=27
#exec MESH SEQUENCE MESH=plaunlft SEQ=Select   STARTFRAME=0   NUMFRAMES=5 RATE=5 GROUP=Select
#exec MESH SEQUENCE MESH=plaunlft SEQ=Still    STARTFRAME=5  NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunlft SEQ=altfire    STARTFRAME=5  NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunlft SEQ=sway     STARTFRAME=5  NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunlft SEQ=Fire    STARTFRAME=6  NUMFRAMES=4 rate=4
#exec MESH SEQUENCE MESH=plaunlft SEQ=loading    STARTFRAME=9  NUMFRAMES=11 rate=6
#exec MESH SEQUENCE MESH=plaunlft SEQ=Down     STARTFRAME=20 NUMFRAMES=6 

#exec MESHMAP NEW   MESHMAP=plaunlft MESH=plaunlft
#exec MESHMAP SCALE MESHMAP=plaunlft X=0.008 Y=0.008 Z=0.016
#exec MESHMAP SETTEXTURE MESHMAP=plaunlft NUM=0 TEXTURE=jrlauncher
#exec MESHMAP SETTEXTURE MESHMAP=plaunlft NUM=1 TEXTURE=jrlauncher1
#exec MESHMAP SETTEXTURE MESHMAP=plaunlft NUM=2 TEXTURE=jrlauncher2


///pickup///

#exec MESH IMPORT MESH=plaunpk ANIVFILE=Models\plaunpk_a.3D DATAFILE=Models\plaunpk_d.3D unmirror=1
#exec MESH ORIGIN MESH=plaunpk X=-5 Y=-125 Z=-30 YAW=-64 
#exec MESH SEQUENCE MESH=plaunpk SEQ=All    STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunpk SEQ=Still  STARTFRAME=0   NUMFRAMES=1
#exec MESHMAP SCALE MESHMAP=plaunpk X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=plaunpk NUM=0 TEXTURE=jrlauncher

///thirdperson///
#exec MESH IMPORT MESH=plaunth ANIVFILE=Models\plaunth_a.3D DATAFILE=Models\plaunth_d.3D unmirror=1
#exec MESH ORIGIN MESH=plaunth X=0 Y=0 Z=0 YAW=-128 
#exec MESH SEQUENCE MESH=plaunth SEQ=All    STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunth SEQ=Still  STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=plaunth SEQ=fire  STARTFRAME=0   NUMFRAMES=1
#exec MESHMAP SCALE MESHMAP=plaunth X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=plaunth NUM=0 TEXTURE=jrlauncher

var bool bLaser;
var scope Sc;
var Lsight ls;

function setHand(float Hand)
{
	Super.SetHand(Hand);

	if ( Hand == 0 )
		PlayerViewOffset.Y = 0;
	if ( Hand == 1 )
		Mesh = mesh(DynamicLoadObject("Respawnables.plaunlft", class'Mesh'));
	else
		Mesh = mesh'plaunrght';
}

simulated function PostRender( canvas Canvas )
{
	local PlayerPawn P;
	local float Scale;

	Super.PostRender(Canvas);
	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) ) 
	{
		bOwnsCrossHair = true;
		bLaser = true;
		Scale = Canvas.ClipX/256;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
	        Canvas.Style = ERenderStyle.STY_modulated;
		Canvas.DrawIcon(Sc.UseTint, Scale);
            Scale = Canvas.ClipX/400;  //was 512
            Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
            Canvas.DrawIcon(Texture'sight2', Scale);
		Scale = Canvas.ClipX/480;
		Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
            Canvas.Style = ERenderStyle.STY_translucent;
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
		
		Scale = Canvas.ClipX/480;
		Canvas.SetPos(0.5 * Canvas.ClipX - 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		Canvas.DrawText("Guide Mode");
	
	}
	else
	{
		bOwnsCrossHair = false;
		bLaser = false;
	}
}

function TraceFirel( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000 ;
	EndTrace += (100000 * vector(AdjustedAim)); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	if(other!=none);
		ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (ls!=none) ls.SetLocation(HitLocation);
	else ls = Spawn(Class'Lsight',Owner);
}

function Fire( float Value )
{
local Vector Start, X,Y,Z;
local Bot B;
local Pawn P;
local Respawnables_Projectile_Guidemissile s;
      
	if ( !bOwnsCrossHair )
	{
		//
		FireOffset.X = 10;
		FireOffset.Y = 11;
		FireOffset.Z = -15;
		//
	}
	else
	{
		//
		FireOffset.X = 0;
		FireOffset.Y = 0;
		FireOffset.Z = 0;
		//
	}
		
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if (AmmoType.UseAmmo(1))
	{
		bCanClientFire = true;
		bPointing=True;
		Start = Owner.Location + CalcDrawOffset();
		B = Bot(Owner);
		P = Pawn(Owner);
		P.PlayRecoil(FiringSpeed);
		Owner.MakeNoise(2.0 * P.SoundDampening);
		AdjustedAim = P.AdjustAim(AltProjectileSpeed, Start, AimError, True, bWarnTarget);
		GetAxes(AdjustedAim,X,Y,Z);		
		Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;	
		s = Spawn( class 'Respawnables_Projectile_Guidemissile',, '', Start, AdjustedAim);
                if ( ls != None && bLaser ) s.Seeking = ls;

		ClientFire(Value);
		GoToState('NormalFire');
	}
}

Simulated Function Tick(Float D)
{
	if (bLaser) TraceFirel(0);
	else if (!bLaser && ls != None) ls.Destroy(); 
}
 
simulated function PlayFiring()
{
	PlayAnim( 'Fire', 1.0, 0.05);
	PlayOwnedSound(class'Respawnables_Weapon_Bazooka'.Default.FireSound, SLOT_None, 4.0*Pawn(Owner).SoundDampening);	
	
}

/*
simulated function bool ClientAltFire( float Value )
{
	//GotoState('Zooming');
	return true;
}
*/

function AltFire( float Value )
{
	local Vector Start, X,Y,Z;
	local Bot B;
	local Pawn P;
        local missile2 s;
      
	if ( !bOwnsCrossHair )
	{
		//
		FireOffset.X = 10;
		FireOffset.Y = 11;
		FireOffset.Z = -15;
		//
	}
	else
	{
		//
		FireOffset.X = 0;
		FireOffset.Y = 0;
		FireOffset.Z = 0;
		//
	}
		
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if (AmmoType.UseAmmo(1))
	{
		bCanClientFire = true;
		bPointing=True;
		Start = Owner.Location + CalcDrawOffset();
		B = Bot(Owner);
		P = Pawn(Owner);
		P.PlayRecoil(FiringSpeed);
		Owner.MakeNoise(2.0 * P.SoundDampening);
		AdjustedAim = P.AdjustAim(AltProjectileSpeed, Start, AimError, True, bAltWarnTarget);
		GetAxes(AdjustedAim,X,Y,Z);		
		Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;	
		s = Spawn( class 'missile2',, '', Start, AdjustedAim);
                if ( ls != None && bLaser ) s.Seeking = ls;

		ClientFire(Value);
		GoToState('NormalFire');
	}
}

// not used either
/*
state Zooming
{
     function endstate()
     {
     super.endstate();
     }

     function DoZoom()
	{
     		if (playerpawn(owner) != none && ammotype.ammoamount > 0)
        		{
         		if (playerpawn(owner).desiredfov == playerpawn(owner).defaultfov)
         		    	playerpawn(owner).desiredfov = 22.5;
        		else
				playerpawn(owner).desiredfov = playerpawn(owner).defaultfov;
       			}
	}

begin:
	DoZoom();
	Sleep(0.25);
	GotoState('Idle'); 
            
}


state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).StopZoom();
			SetTimer(0.0,False);
			GoToState('Idle');
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
			SetTimer(0.2,True);
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}
*/

////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////
simulated function PlayReloading()
{
	PlayAnim('Loading',0.7, 0.05);
	Owner.PlayOwnedSound(CockingSound, SLOT_None,0.5*Pawn(Owner).SoundDampening);		
}

simulated function PlayFastReloading()
{
	PlayAnim('Loading',1.1, 0.05);
	Owner.PlayOwnedSound(CockingSound, SLOT_None,0.5*Pawn(Owner).SoundDampening);		
}

state ClientReload
{
	simulated function bool ClientFire(float Value)
	{
		bForceFire = bForceFire || ( bCanClientFire && (Pawn(Owner) != None) && (AmmoType.AmmoAmount > 0) );
		return bForceFire;
	}

	simulated function bool ClientAltFire(float Value)
	{
		bForceAltFire = bForceAltFire || ( bCanClientFire && (Pawn(Owner) != None) && (AmmoType.AmmoAmount > 0) );
		return bForceAltFire;
	}

	simulated function AnimEnd()
	{
		if ( bCanClientFire && (PlayerPawn(Owner) != None) && (AmmoType.AmmoAmount > 0) )
		{
			if ( bForceFire || (Pawn(Owner).bFire != 0) )
			{
				Global.ClientFire(0);
				return;
			}
			else if ( bForceAltFire || (Pawn(Owner).bAltFire != 0) )
			{
				Global.ClientAltFire(0);
				return;
			}
		}			
		GotoState('');
		Global.AnimEnd();
	}

	simulated function EndState()
	{
		bForceFire = false;
		bForceAltFire = false;
	}

	simulated function BeginState()
	{
		bForceFire = false;
		bForceAltFire = false;
	}
}

state ClientFiring
{
	simulated function AnimEnd()
	{
		if ( (Pawn(Owner) == None) || (Ammotype.AmmoAmount <= 0) )
		{
			PlayIdleAnim();
			GotoState('');
		}
		else if ( !bCanClientFire )
			GotoState('');
		else
		{
			PlayFastReloading();
			GotoState('ClientReload');
		}
	}
}



state NormalFire
{
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}

	function AnimEnd()
	{
		if ( (AnimSequence != 'Loading') && (AmmoType.AmmoAmount > 0) )
			PlayFastReloading();
		else
			Finish();
	}
		
Begin:
	
}

///////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
/*
simulated function TweenDown()
{

	ls.Destroy();
	Super.TweenDown();
      blaon=false;
	if ( IsAnimating() && (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
		TweenAnim( AnimSequence, AnimFrame * 0.4 );
	else if ( AmmoType.AmmoAmount < 1 )
		TweenAnim('Select', 0.5);
	else
		PlayAnim('Down',1.0, 0.05);

}
*/
simulated function PlayIdleAnim()
{
}

simulated function PlayPostSelect()
{
	PlayAnim('Loading', 1.1, 0.05);
	Owner.PlayOwnedSound(Misc2Sound, SLOT_None,1.3*Pawn(Owner).SoundDampening);

	if(PlayerPawn(Owner) != None && Pawn(Owner).FindInventoryType(class'scope')==None) 
	{		
		Sc = Spawn(class'scope');
		if( Sc != None )
		{
			Sc.bHeldItem = true;
			Sc.bUseBazooka = true;
			Sc.RespawnTime = 0.0;
			Sc.GiveTo(Pawn(Owner));
		}
	}
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist, Rating;
	local bool bRetreating;
	local vector EnemyDir;
	local Pawn P;

	P = Pawn(Owner);
	if ( P.Enemy == None )
		return AIRating;	

	EnemyDir = P.Enemy.Location - Owner.Location; 
	EnemyDist = VSize(EnemyDir);
	Rating = AIRating;

	// don't recommend self if out of ammo
	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	// by default use regular mode (rockets)
	
	if (EnemyDist < 1500)
	{
		if (FRand() > 0.4) bUseAltMode = 1;
	}
	else	bUseAltMode = 0;
	
	// if standing on a lift, make sure not about to go around a corner and lose sight of target
	// (don't want to blow up a rocket in bot's face)
	if ( (P.Base != None) && (P.Base.Velocity != vect(0,0,0))
		&& !P.CheckFutureSight(0.1) )
		return 0.1;

	

	// don't pick rocket launcher if enemy is too close
	if ( EnemyDist < 340 )
	{
		if ( P.Weapon == self )
		{
			// don't switch away from rocket launcher unless really bad tactical situation
			if ( (EnemyDist > 260) || ((P.Health < 50) && (P.Health < P.Enemy.Health - 30)) )
				return Rating;
		}
		return 0.05 + EnemyDist * 0.001;
	}

	// increase rating for situations for which rocket launcher is well suited
	if ( P.Enemy.IsA('StationaryPawn') )
		Rating += 0.4;

	// rockets are good if higher than target, bad if lower than target
	if ( Owner.Location.Z > P.Enemy.Location.Z + 120 )
		Rating += 0.25;
	else if ( P.Enemy.Location.Z > Owner.Location.Z + 160 )
		Rating -= 0.35;
	else if ( P.Enemy.Location.Z > Owner.Location.Z + 80 )
		Rating -= 0.05;

	return Rating;
}

// return delta to combat style while using this weapon
function float SuggestAttackStyle()
{
	local float EnemyDist;

	// recommend backing off if target is too close
	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
	if ( EnemyDist < 600 )
	{
		if ( EnemyDist < 300 )
			return -1.5;
		else
			return -0.7;
	}
	else
		return -0.2;
}

defaultproperties
{
    AmmoName=Class'miniammo'
    PickupAmmoCount=3
    bWarnTarget=True
    bAltWarnTarget=True
    bSplashDamage=True
    FiringSpeed=1.00
    FireOffset=(X=25.00,Y=-11.00,Z=2.00),
    ProjectileClass=Class'guidemissile'
    shakemag=500.00
    shaketime=0.60
    shakevert=10.75
    AIRating=0.78
    RefireRate=0.25
    AltRefireRate=0.25
    FireSound=Sound'UnrealShare.Eightball.Ignite'
    CockingSound=Sound'UnrealShare.Eightball.Loading'
    SelectSound=Sound'UnrealShare.Eightball.Selecting'
    Misc1Sound=Sound'UnrealShare.Eightball.BarrelMove'
    InventoryGroup=9
    PickupMessage="You got the Bazooka"
    ItemName="Bazooka"
    PlayerViewOffset=(X=1.85,Y=-1.20,Z=-0.07),
    PlayerViewMesh=LodMesh'plaunrght'
    PlayerViewScale=1.25
    PickupViewMesh=LodMesh'plaunpk'
    ThirdPersonMesh=LodMesh'plaunth'
    StatusIcon=Texture'Botpack.Icons.Use8ball'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    Mesh=LodMesh'plaunpk'
    bNoSmooth=False
}
